/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;

public class FramedChestBlockEntity
extends FramedStorageBlockEntity {
    public static final Component TITLE = Utils.translate("title", "framed_chest");
    private int openCount = 0;
    private long closeStart = 0L;
    private long lastChangeTime = 0L;
    private ChestState lastState = ChestState.CLOSED;

    public FramedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedChest.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedChestBlockEntity tile) {
        if (!level.m_5776_() && level.m_46467_() - tile.closeStart >= 10L && state.m_61143_(PropertyHolder.CHEST_STATE) == ChestState.CLOSING) {
            tile.closeStart = 0L;
            level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)));
        }
    }

    @Override
    public void open(ServerPlayer player) {
        if (this.m_58900_().m_61143_(PropertyHolder.CHEST_STATE) != ChestState.OPENING) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.OPENING)));
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
        ++this.openCount;
        super.open(player);
    }

    public void close() {
        if (this.openCount > 0) {
            --this.openCount;
            if (this.openCount == 0) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(PropertyHolder.CHEST_STATE, (Comparable)((Object)ChestState.CLOSING)));
                this.closeStart = this.f_58857_.m_46467_();
            }
        }
    }

    public long getLastChangeTime(ChestState state) {
        if (this.lastChangeTime == 0L || state != this.lastState) {
            if (this.lastState == ChestState.CLOSING && state == ChestState.OPENING || this.lastState == ChestState.OPENING && state == ChestState.CLOSING) {
                long diff = this.f_58857_.m_46467_() - this.lastChangeTime;
                this.lastChangeTime = this.f_58857_.m_46467_() - (diff < 10L ? 10L - diff : 0L);
            } else {
                this.lastChangeTime = this.f_58857_.m_46467_();
            }
            this.lastState = state;
        }
        return this.lastChangeTime;
    }

    @Override
    protected Component getDefaultName() {
        return TITLE;
    }
}

